﻿$(function(){
	// 加载查询列表
	creatGrid();
});
/**
 * easyUi dataGrid注册方式说明，防止二次渲染 class注册方式一般是为了初始化属性，js方式则属性和事件都可初始化
 * 但是不管是class方式还是js方式注册组件，每次注册，只要被设置过url属性就会做请求。
 * 所以在不可避免要使用js方式注册的情况下，索性就不要使用class方式注册了。
 */
function creatGrid() {
	$('#courseList').datagrid({
		fit : true,// 设置为true时铺满它所在的容器.
		fitColumns : true,// 设置为true将自动使列适应表格宽度以防止出现水平滚动
		nowrap : false,// 设置为true，当数据长度超出列宽时将会自动截取。
		striped : true,// 设置为true将交替显示行背景。
		collapsible : true,// 定义是否显示可折叠按钮。
		singleSelect : false,// 设置为true将只允许选择一行。
		border : false,
		remoteSort : false,// 定义是否通过远程服务器对数据排序。
		pagination : true,// 分页组件是否显示
		pageNumber : 1,// 起始页
		pageSize : 10,// 每页显示的记录条数，默认为10
		pageList : [ 10, 20, 50 ],// 每页显示多少行
		rownumbers : true,// 行号
		url : baseUrl+'/admin/C011/listLiveCourses.html',
		toolbar : '#tbar',
		frozenColumns : [ [ {
			field : 'select',
			title : 'select',
			width : 50,
			checkbox : true
		} ] ],
		columns : [ [ {
			field : 'id',
			title : 'course ID',
			width : 50,
			halign: 'center',
			align : 'right',
			sortable : true,
			sorter : datasort
		},{
			field : 'name',
			title : 'Course name',
			width : 120,
			halign: 'center',
			align : 'left',
			sortable : true,
			sorter : datasort
		}, {
			field : 'lecturerName',
			title : 'lecturer name',
			width : 80,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'left'
		}, {
			field : 'liveDate',
			title : 'live date',
			width : 200,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'left'
		}, {
			field : 'beginTm',
			title : 'start time',
			width : 45,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'right'

		}, {
			field : 'endTm',
			title : 'end time',
			width : 45,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'right'

		}, {
			field : 'insUser',
			title : 'user name',
			width : 80,
			sortable : true,
			sorter : datasort,
			align : 'left'
		}, {
			field : 'updDate',
			title : 'updated Date',
			width : 80,
			sortable : true,
			sorter : datasort,
			halign: 'center',
			align : 'center'
		}, {
			field : 'manage',
			title : 'manage',
			halign: 'center',
			align : 'center',
			width : 100,
			formatter : operate
		} ] ],
		// 当数据载入成功时触发。
		onLoadSuccess : function(data) {
			$('.edit_course').linkbutton({
				iconCls : 'icon-edit',
				plain : true
			});
			$('.drop_course').linkbutton({
				iconCls : 'icon-no',
				plain : true
			});
		}
	});
}
//sort
function datasort(a, b) {
	return (a > b ? 1 : -1);
}
// 操作
function operate(value, rowData, rowIndex) {
	var id = rowData.id;
	return "<a href='javascript:updInfo("+id+");'  class='edit_course'>edit</a><a onclick='delById("
			+ id + ");' class='drop_course' >delete</a>";
}
// 刷新
function reloadGrid() {
	$('#courseList').datagrid('clearSelections');
	$('#courseList').datagrid('reload');
}
// 查询
function findCourse() {
	// 课程名称
	var courseName = $("#courseName").val();
	// 学时开始时间
	var liveDate = $("#liveDate").next().find(".textbox-value").val();
	// user name
	var createPeople = $("#createPeople").val();
	$('#courseList').datagrid('load', {
		courseName : courseName,
		liveDate : liveDate,
		createPeople:createPeople
	});
}
// 添加课程
function addCourse() {
	window.parent.openTab("adding today live course", baseUrl+"/admin/C011/manageAddLiveCourseLoad.html");
}
// 删除课程
function delCourse() {
	var items_id = new Array();
	var items = $('#courseList').datagrid('getSelections');
	if (items.length <= 0) {
		$.messager.alert('Hint', 'Please select the course need deleted', 'info');
		return;
	}
	$.messager.confirm('delete Hint', 'make sure to delete the selected course?', function(r) {
		if (r) {
			// 获取选中课程的ID，并组成集合
			for ( var i = 0; i < items.length; i++) {
				items_id.push(items[i].id);
			}
			$.post(baseUrl+"/admin/C011/removeLiveCourse.html", {
				cid : items_id
			}, function(data) {
				if (data > 0) {
					msgShow('Delete success!');
					reloadGrid();
				} else {
					msgShow('delete failure，Please try again later');
					reloadGrid();
				}
			}, "json");
		}
	});
}
// 根据ID删除
function delById(id) {
	var items_id = new Array();
	items_id.push(id);
	$.messager.confirm('delete hint', 'make sure to delete this course?', function(r) {
		if (r) {
			$.post(baseUrl+"/admin/C011/removeLiveCourse.html", {
				cid : items_id
			}, function(data) {
				if (data > 0) {
					msgShow('Delete success!');
					reloadGrid();
				} else {
					msgShow('delete failure，Please try again later');
					reloadGrid();
				}
			}, "json");
		}
	});
}
function updInfo(id){
	window.parent.closeTabByTitle("edit today live course");
	window.parent.openTab("edit today live course", baseUrl+"/admin/C011/manageLiveCourseLoad.html?courseId="+id);
}